#!/usr/bin/env bash
# check_bits.sh – tell you how many more bits (or symbols) you need for a full page

set -euo pipefail

usage() {
    echo "Usage: $0 <cards> <dice> <coins>"
    echo "  cards  – number of card entries you already have"
    echo "  dice   – number of die rolls you already have"
    echo "  coins  – number of coin flips you already have"
    exit 1
}
[[ $# -eq 3 ]] || usage

cards=$1
dice=$2
coins=$3

bits=$((6*cards + 3*dice + 1*coins))
needed=$((1800 - bits))

if (( needed <= 0 )); then
    echo "[OK] You already have enough bits for a full page (bits = $bits)."
else
    echo "[INFO] You still need $needed more bits."
    # Suggest a simple way to fill the gap with coins (1 bit each)
    echo "      → e.g., add $needed more coin flips (H/T)."
fi